//Copyright Paul Cooper 2023 Version 0.8.0

var ZOOM = 1.25;

var MAPWIDTH = 800 * ZOOM, MAPHEIGHT = 400 * ZOOM;
var SCREENWIDTH = 900, SCREENHEIGHT = (768 - 60);
var CLIPLEFT = (SCREENWIDTH * ZOOM - MAPWIDTH) / 2, CLIPRIGHT = CLIPLEFT + MAPWIDTH; 
var CLIPTOP = 12 * ZOOM, CLIPBOTTOM = CLIPTOP + MAPHEIGHT;
var LEFTPANEL = 200 * ZOOM;
var RIGHTPANEL = 200 * ZOOM;
var S;
var defaultViewer,defaultDist;

var init_seeds=[74,90,72,2,83,183];
var current_seeds=init_seeds.slice(0);

var galaxyNumber = 0;
var systems = [];
var systemLinks = [];
var links = [];
var offsetLabelFactor = 7;
var svgDoc, svgRoot, tooltip, embedNode, tooltipbox, tooltipgroup;
var svgResolver;
var showAlerts = false;
var vTextAlignOffset = 12;
var tipToolMargin = 3;
useSVG=true;//you can also change this by hand
var def_centre_x = 0, def_centre_y = 0, def_centre_z = 0, def_zoom = 3;
var centre_x = def_centre_x, centre_y = def_centre_y, centre_z = def_centre_z, zoom = def_zoom, zoomFactor = 1;
var buttonLeft = 0;
var selectSize = 15, selectidxs = [];
var route = null;
var routeType = "distance";
var DRAW3D = false;
var DRAW2DSystemIconOrderWeight=new Vector(0.1, 0.1, 0.1);
//var shiftkey;
var searchList = null;
var separation = 6/zoomFactor, sepStart = 30/zoomFactor, sepFinish = 15/zoomFactor;
var galOffsets = [];
var pageFreeze = [];
var lineWidth, baseLineColour;


pageFreeze["galaxy_seed"] = false;
pageFreeze["save_seed"] = false;


var closezoom = false;

var galList = [];
var comboList = [];

var blurStack = [];
var blurDiv = null;

var save_button_disabled = false;

var current_seed_name = "Oolite Default";


var styles = {circleStyle: "None", ringStyle: "None", sizeStyle: "None"};

var defaultStylingFuncArr0 = {
	aOptions: styles,
	aFrontColor: () => "#0000ff", 
	aStrokeColor: () => "#004080",
	aStrokeWeight: () => 0,
	aSystemShape: () => "Circle",
	aSystemSize: () => 0
};

var defaultStylingFuncArr1 = {
	aOptions: styles,
	aFrontColor: () => "#0000ff", 
	aStrokeColor: () => "#004080",
	aStrokeWeight: () => 0.5,
	aSystemShape: () => "Circle",
	aSystemSize: () => 0
};

var defaultStylingFuncArr2 = {
	aOptions: styles,
	aFrontColor: () => "#0000ff",
	aFrontColor2: () => "#0000ff",
	aStrokeColor: () => "#004080",
	aStrokeWeight: () => 0,
	aSystemShape: () => "Circle",
	aSystemSize: () => 0
};

var styling = Object.assign({}, defaultStylingFuncArr1);
var stylingFuncObject = null;


var systemStyleFunc = getStylingFactory(styles);

Array.prototype.equals = function (array) 
{
    // if the other array is a falsy value, return
    if (!array)
        return false;

    // compare lengths - can save a lot of time 
    if (this.length != array.length)
        return false;

    for (var i = 0, l=this.length; i < l; i++) {

        // Check if we have nested arrays
        if (this[i] instanceof Array && array[i] instanceof Array) {

            // recurse into the nested arrays
            if (!this[i].equals(array[i]))
                return false;       
        }           
        else if (this[i] != array[i]) {

            // Warning - two different object instances will never be equal: {x:20} != {x:20}
            return false;   
        }           
    }

    return true;
}

function Init()
{ 

	toggle3D();
	resetRadiobuttons("galaxy");
	resetRadiobuttons("mode");
	resetTextBox("search1");
	resetTextBox("search2");
	if (useSVG)
	{ 
		if (! SVGObjects[0])
		{ setTimeout("Init()",100); 
		return;
		}
		S=new Scene3D(SVGObjects[0],0,SCREENWIDTH * ZOOM,SCREENHEIGHT * ZOOM);
		defaultViewer = new Vector(S.Viewer.x, S.Viewer.y, S.Viewer.z);
		defaultDist = S.Dist;
	}
	else S=new Scene3D(document.getElementById("Scene1"),1);

	document.getElementById("search1").focus();

	svgDoc = document.getElementById("embed").getSVGDocument();
	svgRoot = svgDoc.getElementsByTagName("svg")[0];
	svgResolver = svgDoc.createNSResolver(svgDoc.documentElement);

	//Create Selector Group
	var selectorgroup = svgDoc.createElementNS("http://www.w3.org/2000/svg", "g");
	
	let map_area = svgDoc.getElementById("map-area-rect");
	map_area.setAttribute("x", CLIPLEFT);
	map_area.setAttribute("y", CLIPTOP);
	map_area.setAttribute("width", MAPWIDTH);
	map_area.setAttribute("height", MAPHEIGHT);
	
	let map_area_border = svgDoc.getElementById("map-area-border-rect");
	map_area_border.setAttribute("x", CLIPLEFT-1);
	map_area_border.setAttribute("y", CLIPTOP-1);
	map_area_border.setAttribute("width", MAPWIDTH+2);
	map_area_border.setAttribute("height", MAPHEIGHT+2);
	
	
	selectorgroup.className = "selectorgroup";
	selectorgroup.id = "selectorgroup";
	selectorgroup.setAttribute("clip-path", "url(#map-area)");
	svgRoot.appendChild(selectorgroup);
	
	

	//Create Tooltip object
	tooltipgroup = svgDoc.createElementNS("http://www.w3.org/2000/svg", "g");
	tooltipgroup.className = "tooltip";
	tooltipgroup.id = "tooltip";
	tooltipgroup.setAttribute("visibility", "hidden");
	tooltip = svgDoc.createElementNS("http://www.w3.org/2000/svg", "text");
	tooltip.className = "tooltip";
	tooltip.id = "tooltiptext";
	tooltip.setAttribute("x", "0");
	tooltip.setAttribute("y", "0");
	tooltip.setAttribute("style", "font-family: sans-serif;font-size: 10pt;fill: white");
	svgRoot.appendChild(tooltipgroup);
	tooltipgroup.appendChild(tooltip);
	var tooltipbbox = tooltip.getBBox();
	tooltipbox = svgDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
	tooltipbox.className = "tooltip";
	tooltipbox.id = "tooltipbox";
	tooltipbox.setAttribute("x", tooltipbbox.x - 3);
	tooltipbox.setAttribute("y", tooltipbbox.y - 3);
	tooltipbox.setAttribute("width", tooltipbbox.width + 6);
	tooltipbox.setAttribute("height", tooltipbbox.height + 6);
	tooltipbox.setAttribute("style", "fill: #202040;fill-opacity:0.85;stroke: lightgreen");
	tooltipgroup.insertBefore( tooltipbox, tooltip);

	//galaxy selection
	if (supports_html5_storage())
	{
		if (localStorage["firstTime"] === null || localStorage["firstTime"] === undefined)
		{
			localStorage["firstTime"] = "1";
			galList.push(["Oolite Alternative - PhantorGorth", [74,90,72,2,83,55]]);
			galList.push(["Gal 9 to 16 candidate 1 - PhantorGorth", [126,79,72,85,182,92]]);
			galList.push(["Gal 9 to 16 candidate 2 - PhantorGorth", [17,245,0,234,119,178]]);
			galList.push(["Gal 9 to 16 candidate 3 - PhantorGorth", [78,114,72,192,103,173]]);
			galList.push(["Gal 9 to 16 - Pleb87", [21,48,37,3,92,112]]);
			galList.push(["Gal 9 to 16 - Pleb", [42,42,66,1,82,178]]);
			localStorage["galaxyList"] = JSON.stringify(galList);
		}
	}
	addDeleteSaveComboListEntry("None");
	setupGalaxyList(3);

	for(var idx = 0; idx < 256; idx++)
	{
		galOffsets.push([0,0]); // build up 256 zero offsets
	}

	//create Galaxy
	setUpGalaxyData();

	//Draw Galaxy
	reSetUpGalaxy(centre_x, centre_y, centre_z, zoom, systemStyleFunc);
	//S.AutoCenter();
	S.Center.Zoom(0.0);
	//S.ZoomAll*=1.4;
	S.YM-=140*ZOOM;
	S.ChangeViewer(-90,0);
	S.ChangeLight(-95,-30);
	//S.ChangeViewer(0,0);
	//S.ChangeLight(-5,-30);
	S.Sort();
	S.Draw();

	let line = svgDoc.getElementById("MapArea").querySelector("g[id|=Line] path");
	lineWidth = parseInt(line.getAttribute("stroke-width"), 10);
	baseLineColour = line.getAttribute("stroke");
	//if (galOverlaps.length > 0)
	//{
		var ma = svgDoc.getElementById("MapArea");
		ma.setAttribute("onmousemove", "parent.moveOverlapping(evt)");
	//}

}

function Rotate()
{ if (! isRotating) return;
  D.RotateZ(10,1);
  S.ChangeViewer(0,-5);
  S.ChangeLight(0,-5);
  S.Sort();
  S.Draw();
  setTimeout("Rotate()",100);
}

function ChangeViewer(vv, ww)
{ 
	if (ww === null) S.ChangeViewer(vv, 0);
	else S.ChangeViewer(vv, ww);
	if (! isRotating)
	{ 
		S.Sort();
		S.Draw();
	}
}

function ChangeLight(ttheta, ffi)
{ S.ChangeLight(ttheta, ffi);
  if (! isRotating) S.Draw();
}

var viewerzoomed=0;
function ZoomViewer(vv)
{ //if ((viewerzoomed+vv>5)||(viewerzoomed+vv<-5)) return;
  viewerzoomed+=vv;
  if (vv>0) {
		S.Dist*=0.8;
		zoomFactor *= 0.8; 
		S.Viewer.Zoom(0.8);
	}
  else {
		S.Dist/=0.8;
		zoomFactor /= 0.8;
		S.Viewer.Zoom(1/0.8);
	}
  
  if (! isRotating)
  { S.Sort();
    S.Draw();
  }
}

function ShiftView(xx, yy, zz)
{ 
  S.Center.x += xx;
  S.Center.y += yy;
  S.Center.z += zz;	
  if (! isRotating) S.Draw();
}

var picturezoomed=0;
function ZoomPicture(vv)
{ if ((picturezoomed+vv>5)||(picturezoomed+vv<-5)) return;
  picturezoomed+=vv;
  if (vv>0) S.ZoomAll*=1.1;
  else S.ZoomAll/=1.1;
  if (! isRotating) S.Draw();
}

var isRotating=false;
function StartStop()
{ if (isRotating)
  { isRotating=false;
    document.getElementById("StartStop").value="rotate";
  }
  else
  { isRotating=true;
    document.getElementById("StartStop").value="stop";
    Rotate();
  }
}

function ShowTooltip(evt)
{
	if (!evt.currentTarget) evt.currentTarget = evt.srcElement;
	var systemid = parseInt(evt.currentTarget.id);
	var source = systems[systemid];
	var ts, ts1, ts2, ts3, ts4, ts5, ts6;
	removeAllChildren(tooltip);

	//Offset caused by shifting systems
	var offset_x = galOffsets[systemid][0]; 
	var offset_y = galOffsets[systemid][1];

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "name";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "0");
	ts.setAttribute("style", "fill: #4040ff;font-weight: bold");
	ts.textContent = galArray[systemid][4].name;
	tooltip.appendChild(ts);
	
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "key1";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "System No.:";
	tooltip.appendChild(ts);
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "value1";
	ts.textContent = evt.currentTarget.id;
	tooltip.appendChild(ts);

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "key2";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "Position:";
	tooltip.appendChild(ts);
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "value2";
	ts.setAttribute("dy", "0");
	ts.textContent = galArray[systemid][0] + ", " + galArray[systemid][1] + ((DRAW3D) ? ", " + galArray[systemid][2] : "");
	tooltip.appendChild(ts);

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "key3";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "Economy:";
	tooltip.appendChild(ts);
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "value3";
	ts.setAttribute("dy", "0");
	ts.textContent = galArray[systemid][4].economy;
	tooltip.appendChild(ts);

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");

	ts.id = "key4";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "Government:";
	tooltip.appendChild(ts);
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "value4";
	ts.setAttribute("dy", "0");
	ts.textContent = galArray[systemid][4].government;
	tooltip.appendChild(ts);

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "key5";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "Tech Level:";
	tooltip.appendChild(ts);
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "value5";
	ts.setAttribute("dy", "0");
	ts.textContent = "" + galArray[systemid][4].techlevel;
	tooltip.appendChild(ts);

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "key6";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "Population:";
	tooltip.appendChild(ts);
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "value6";
	ts.setAttribute("dy", "0");
	ts.textContent = galArray[systemid][4].population + " Billion";
	tooltip.appendChild(ts);

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "key7";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "Species:";
	tooltip.appendChild(ts);
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "value7";
	ts.setAttribute("dy", "0");
	ts.textContent = galArray[systemid][4].species;
	tooltip.appendChild(ts);

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "key8";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "Productivity:";
	tooltip.appendChild(ts);
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "value8";
	ts.setAttribute("dy", "0");
	ts.textContent = galArray[systemid][4].productivity + " Mcr.";
	tooltip.appendChild(ts);

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "key9";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "Radius:";
	tooltip.appendChild(ts);
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "value9";
	ts.setAttribute("dy", "0");
	ts.textContent = galArray[systemid][4].radius + " Km";
	tooltip.appendChild(ts);

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "key10";
	ts.setAttribute("x", "0");
	ts.setAttribute("dy", "15");
	ts.setAttribute("style", "font-weight: bold");
	ts.textContent = "Description:";
	tooltip.appendChild(ts);

	var ch = tooltip.getElementsByTagName("tspan");
	var maxColumnWidth = 0;
	var columnWidth;
	for (var a = 0; a < ch.length; a++) 
	{
		if (ch[a].id.substr(0,3) == "key")
		{
			columnWidth = ch[a].getComputedTextLength();
			if (columnWidth > maxColumnWidth) maxColumnWidth = columnWidth;
		}
	}

	for (var a = 0; a < ch.length; a++) 
	{
		if (ch[a].id.substr(0,5) == "value") ch[a].setAttribute("x", maxColumnWidth + 5);
	}

	bbox = tooltip.getBBox();

	if (galArray[systemid][4].descArray === undefined) galArray[systemid][4].descArray = wrapText(galArray[systemid][4].description, bbox.width, "font-family: sans-serif;font-size: 10pt;font-weight: normal", maxColumnWidth + 5);
	for (var z = 0; z < galArray[systemid][4].descArray.length; z++)
	{
		ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
		ts.id = "desc-" + z;
		if (z == 0)
		{
			ts.setAttribute("x", maxColumnWidth + 5);
		}
		else 
		{
			ts.setAttribute("x", "0");
			ts.setAttribute("dy", "15");
		}
		ts.setAttribute("style", "font-weight: normal");
		ts.textContent = galArray[systemid][4].descArray[z];
		tooltip.appendChild(ts);
	}

	bbox = tooltip.getBBox();

	var xpos = (S.ScreenPos(source.Center).x + offset_x) + offsetLabelFactor * S.ZoomAll; //- (bbox.width/2);
	var ypos = (S.ScreenPos(source.Center).y + offset_y)  + offsetLabelFactor * S.ZoomAll + vTextAlignOffset;

	if ((xpos + bbox.width) > (CLIPRIGHT - tipToolMargin)) xpos = (S.ScreenPos(source.Center).x + offset_x) - offsetLabelFactor * S.ZoomAll - bbox.width;
	if ((ypos + bbox.height) > (CLIPBOTTOM - tipToolMargin)) ypos = (S.ScreenPos(source.Center).y + offset_y) - offsetLabelFactor * S.ZoomAll - bbox.height + vTextAlignOffset;

	if ((ypos - vTextAlignOffset - tipToolMargin) < (CLIPTOP + tipToolMargin) ) ypos = CLIPTOP + vTextAlignOffset + (2 * tipToolMargin);

	tooltip.setAttribute("x", xpos);
	tooltip.setAttribute("y", ypos);

	for (var a = 0; a < ch.length; a++) 
	{

		if (ch[a].id == "name") { ch[a].x.baseVal.getItem(0).value = xpos + (bbox.width - getStringBBox(ch[a].textContent, ch[a].getAttribute("style")).width) / 2;}
		//if (ch[a].id == "name") { ch[a].x.baseVal[0].value = xpos + (bbox.width - getStringBBox(ch[a].textContent, ch[a].getAttribute("style")).width) / 2;}
		else if ((ch[a].id.substr(0,3) == "key") || ((ch[a].id.substr(0,5) == "desc-") && (ch[a].id != "desc-0"))) {ch[a].x.baseVal.getItem(0).value = xpos;}
		else if ((ch[a].id.substr(0,5) == "value") || (ch[a].id == "desc-0")) {ch[a].x.baseVal.getItem(0).value = xpos + maxColumnWidth + 5;}
	}

	bbox = tooltip.getBBox();
	tooltipbox.setAttribute("x", bbox.x - tipToolMargin);
	tooltipbox.setAttribute("y", bbox.y - tipToolMargin);
	tooltipbox.setAttribute("width", bbox.width + (2 * tipToolMargin));
	tooltipbox.setAttribute("height", bbox.height + (2 * tipToolMargin));
	tooltipgroup.setAttribute("visibility", "visible");

}

function HideTooltip()
{
	//if (!evt.currentTarget) evt.currentTarget = evt.srcElement;
	
	tooltipgroup.setAttribute("visibility", "hidden");
}

function reSetUpGalaxy(x, y, z, zoom, systemStyleFunc)
{
	S.Delete();
	
	for(var idx = 0; idx < 256; idx++)
	{
		galOffsets[idx] = [0,0]; // reset offsets
	}

	systems.length = 0;
	links.length = 0;
	lengthCutOff = 5;
	var colour;
	for (var idx = 0; idx < galArray.length; idx++)
	{
		styling = systemStyleFunc(galArray[idx], stylingFuncObject);
		//console.log(idx + " " + JSON.stringify(styling));
		systems[idx] = new SystemIcon(S, 5, 50, styling);
		systems[idx].Shift((galArray[idx][1]-64-x)*zoom, (galArray[idx][0]-128-y)*zoom, (galArray[idx][2]-16-z)*zoom);
		if (!DRAW3D) systems[idx].SetOrderWeight(DRAW2DSystemIconOrderWeight);
		systems[idx].SetId(idx);
		systems[idx].SetEventAction("mouseover",parent.ShowTooltip);
		systems[idx].SetEventAction("mouseout",parent.HideTooltip);
		systems[idx].SetEventAction("click",parent.onClickSystem);
		//systems[idx].SetEventAction("mousedown",parent.mouseDownModifierCheck);
		for (var idx2 = 0; idx2 < systemLinks[idx].length; idx2++)
		{
			if (ooliteDist(galArray[idx][0], galArray[idx][1], galArray[idx][2], galArray[systemLinks[idx][idx2][0]][0], galArray[systemLinks[idx][idx2][0]][1], galArray[systemLinks[idx][idx2][0]][2]) <= 7) colour = "#ffff00";
			else colour = "#800000";
			var x1 = (galArray[idx][1]-64-x)*zoom;
			var y1 = (galArray[idx][0]-128-y)*zoom;
			var z1 = (galArray[idx][2]-16-z)*zoom;
			var x2 = (galArray[systemLinks[idx][idx2][0]][1]-64-x)*zoom;
			var y2 = (galArray[systemLinks[idx][idx2][0]][0]-128-y)*zoom;
			var z2 = (galArray[systemLinks[idx][idx2][0]][2]-16-z)*zoom;
			var len = Math.sqrt((x2-x1)*(x2-x1) + (y2-y1)*(y2-y1) + (z2-z1)*(z2-z1));
			var dx = (x2-x1)*lengthCutOff/len;
			var dy = (y2-y1)*lengthCutOff/len;
			var dz = (z2-z1)*lengthCutOff/len;
			if (len == 0)
			{
				dx = 0;
				dy = 0;
				dz = 0;
			}
			x1 += dx;
			y1 += dy;
			z1 += dz;
			x2 -= dx;
			y2 -= dy;
			z2 -= dz;
			if (idx < systemLinks[idx][idx2][0])
			{
				links[links.length] = new Line(S, x1, y1, z1, x2, y2, z2, colour, 1);
				links[links.length-1].SetId("Line-"+idx+"-"+systemLinks[idx][idx2][0]);
				//links[links.length-1].Poly3D[0].VisFunc = LinkVisible;
			}
		}
	}

}

function LinkVisible(aPoly)
{
	var id = this.Id.substr(5);
	var id1 = id.substr(0, id.indexOf("-"));
	var id2 = id.substr(id.indexOf("-")+1);
	var poly1 = this.Parent.GetPolyForId(id1);
	var poly2 = this.Parent.GetPolyForId(id2);
	if ((this.Parent.PolyRank[this.Parent.GetPolyRankForPoly(poly1)][2] < 0) && (this.Parent.PolyRank[this.Parent.GetPolyRankForPoly(poly2)][2] < 0)) return "visible";
	else return "hidden";
}

function ChangeGalaxy()
{
	removeRoute(0);
	selectidxs.map((e,i) => i).forEach(e => removeSelector("select" + (e + 1)));
	selectidxs.splice(0);
	redrawSelectors();
	removeRouteDetails()
	route = null;
	resetTextBox("search1");
	resetTextBox("search2");
	removeSearchResults("no unhide");
	removeSelectorsByClassName("searchlist");
	routeType = "distance";
	galaxyNumber = parseInt(getCheckedRadioValue("galaxy"));
	//galaxyNumber = parseInt(document.getElementById("GalaxyNumber").options[document.getElementById("GalaxyNumber").selectedIndex].value);
	setUpGalaxyData();
	centre_x = def_centre_x;
	centre_y = def_centre_y;
	centre_z = def_centre_z;
	zoom = def_zoom;
	zoomFactor = 1;
	resetView();
	reSetUpGalaxy(centre_x, centre_y, centre_z, zoom, systemStyleFunc);
	//S.AutoCenter();
	S.Center.Zoom(0.0);
	//S.ZoomAll*=1.4;
	//S.YM-=140;
	S.ChangeViewer(-S.Th,-S.Fi);
	S.ChangeViewer(-90,0);
	S.ChangeLight(-S.ThLight,-S.FiLight);
	S.ChangeLight(-95,-30);
	S.Sort();
	S.Draw();
}

function resetView()
{
	centre_x = def_centre_x;
	centre_y = def_centre_y;
	centre_z = def_centre_z;
	closezoom = false;
	zoom = def_zoom;
	zoomFactor = 1;
	S.Center.Zoom(0.0);
	S.Dist = defaultDist;
	S.Viewer.x = defaultViewer.x;
	S.Viewer.y = defaultViewer.y;
	S.Viewer.z = defaultViewer.z;
	S.ChangeViewer(-S.Th,-S.Fi);
	S.ChangeViewer(-90,0);
	S.ChangeLight(-S.ThLight,-S.FiLight);
	S.ChangeLight(-95,-30);
	S.Sort();
	S.Draw();
}

function setUpGalaxyData()
{
	galArray.length = 0;
	systemLinks.length = 0;
	createGalaxyCoordsArray(galaxyNumber, galArray, current_seeds);
}

function removeAllChildren(node)
{
	if ( node.hasChildNodes() )
	{
		while ( node.childNodes.length >= 1 )
		{
			node.removeChild( node.firstChild );
		} 
	}
}

function wrapText(str, textLength, style, initialLineOffset)
{
	var re =/<tspan class="[a-z\-]+?">[^<\s]*?<\/tspan>,?|<tspan class="[a-z\-]+?">[^<\s]+|[^<\s]*?<\/tspan>,?|\S+/g;
	var wordArray = str.match(re);
	var linesArray = [];
	var line = 0;
	var spacing;
	var lineLength = 0;
	if (initialLineOffset !== undefined) lineLength = initialLineOffset;	
	var bbox;
	var flag = false;
	var ts;

	for(var idx = 0; idx < wordArray.length; idx++)
	{
		if ((linesArray[line] === null) || (linesArray[line] === undefined)) spacing = "";
		else spacing = "\u00a0"; //non-breaking space
		let word = wordArray[idx].replace(/<\/?tspan[^>]*>/g, "");
		bbox = getStringBBox(spacing + word, style);

		if ((lineLength + bbox.width) <= textLength)
		{
			if (linesArray[line] === undefined) linesArray[line] = spacing + wordArray[idx];
			else linesArray[line] += spacing + wordArray[idx];
			lineLength += bbox.width;
		}
		else if (bbox.width > textLength)
		{
			for(var z = (spacing + word).length; z > 2; z--)
			{
				if ((lineLength + getStringBBox((spacing + word).substr(0, z) + "-", style).width) <= textLength)
				{
					if (linesArray[line] === undefined) linesArray[line] = (spacing + wordArray[idx]).substr(0, z) + "-";
					else linesArray[line] += (spacing + wordArray[idx]).substr(0, z) + "-";
					line++;
					lineLength = 0;
					break;
				}
				else flag = true;
				if ((lineLength == 0) && (z == 3)) return null;
			}
		}
		else flag = true;

		if (flag) //Add to new line
		{
			line++;
			lineLength = 0;
			idx--;
			flag = false;
		}
	}

	return linesArray;
}

function getStringBBox(str, style)
{
	var t = svgRoot.getElementById("getStringBBox");
	if (t !== null) t.parentNode.removeChild(t);
	t = svgDoc.createElementNS("http://www.w3.org/2000/svg", "text");
	t.setAttribute("x", "0");
	t.setAttribute("y", "0");
	t.setAttribute("style", style);
	t.setAttribute("visibility", "hidden");
	t.textContent = str;
	t.id = "getStringBBox"
	svgRoot.appendChild(t);
	var bbox = t.getBBox();
	t.parentNode.removeChild(t);
	return bbox;
}

function addSelector(name, inclass, systemid, x, y, size, style)
{
	var sg = svgRoot.getElementById("selectorgroup");

	var s = svgRoot.getElementById(name);
	if (s !== null) s.parentNode.removeChild(s);

	var offset_x = galOffsets[systemid][0];
	var offset_y = galOffsets[systemid][1];

	//Create Selector
	selector = svgDoc.createElementNS("http://www.w3.org/2000/svg", "g");
	selector.setAttribute("class", inclass);
	selector.id = name;
	selector.setAttribute("systemid", systemid);
	selector.setAttribute("style", style);
	if ((offset_x != 0) && (offset_y != 0))
	{
		selector.setAttribute("transform", "translate(" + offset_x + " " + offset_y + ")"); 
	}
	selector.setAttribute("visibility", "visible");
	sg.appendChild(selector);

	

	s = svgDoc.createElementNS("http://www.w3.org/2000/svg", "line");
	s.setAttribute("x1", (x-(size/2)).toString());
	s.setAttribute("y1", (y-(size/2)).toString());
	s.setAttribute("x2", (x-(size/2) + (size/3)).toString());
	s.setAttribute("y2", (y-(size/2)).toString());
	s.setAttribute("stroke-linecap", "square");
	selector.appendChild(s);
	s = svgDoc.createElementNS("http://www.w3.org/2000/svg", "line");
	s.setAttribute("x1", (x-(size/2)).toString());
	s.setAttribute("y1", (y-(size/2)).toString());
	s.setAttribute("x2", (x-(size/2)).toString());
	s.setAttribute("y2", (y-(size/2) + (size/3)).toString());
	s.setAttribute("stroke-linecap", "square");
	selector.appendChild(s);

	s = svgDoc.createElementNS("http://www.w3.org/2000/svg", "line");
	s.setAttribute("x1", (x+(size/2)).toString());
	s.setAttribute("y1", (y-(size/2)).toString());
	s.setAttribute("x2", (x+(size/2) - (size/3)).toString());
	s.setAttribute("y2", (y-(size/2)).toString());
	s.setAttribute("stroke-linecap", "square");
	selector.appendChild(s);
	s = svgDoc.createElementNS("http://www.w3.org/2000/svg", "line");
	s.setAttribute("x1", (x+(size/2)).toString());
	s.setAttribute("y1", (y-(size/2)).toString());
	s.setAttribute("x2", (x+(size/2)).toString());
	s.setAttribute("y2", (y-(size/2) + (size/3)).toString());
	s.setAttribute("stroke-linecap", "square");
	selector.appendChild(s);

	s = svgDoc.createElementNS("http://www.w3.org/2000/svg", "line");
	s.setAttribute("x1", (x-(size/2)).toString());
	s.setAttribute("y1", (y+(size/2)).toString());
	s.setAttribute("x2", (x-(size/2) + (size/3)).toString());
	s.setAttribute("y2", (y+(size/2)).toString());
	s.setAttribute("stroke-linecap", "square");
	selector.appendChild(s);
	s = svgDoc.createElementNS("http://www.w3.org/2000/svg", "line");
	s.setAttribute("x1", (x-(size/2)).toString());
	s.setAttribute("y1", (y+(size/2)).toString());
	s.setAttribute("x2", (x-(size/2)).toString());
	s.setAttribute("y2", (y+(size/2) - (size/3)).toString());
	s.setAttribute("stroke-linecap", "square");
	selector.appendChild(s);

	s = svgDoc.createElementNS("http://www.w3.org/2000/svg", "line");
	s.setAttribute("x1", (x+(size/2)).toString());
	s.setAttribute("y1", (y+(size/2)).toString());
	s.setAttribute("x2", (x+(size/2) - (size/3)).toString());
	s.setAttribute("y2", (y+(size/2)).toString());
	s.setAttribute("stroke-linecap", "square");
	selector.appendChild(s);
	s = svgDoc.createElementNS("http://www.w3.org/2000/svg", "line");
	s.setAttribute("x1", (x+(size/2)).toString());
	s.setAttribute("y1", (y+(size/2)).toString());
	s.setAttribute("x2", (x+(size/2)).toString());
	s.setAttribute("y2", (y+(size/2) - (size/3)).toString());
	s.setAttribute("stroke-linecap", "square");
	selector.appendChild(s);
}

function removeSelector(name)
{
	var s = svgRoot.getElementById(name);
	if (s !== null) s.parentNode.removeChild(s);
}

function removeSelectorsByClassName(classname)
{
	var s = svgRoot.getElementsByClassName(classname);
	if (s !== null) 
	{
		for(var idx = (s.length - 1); idx >= 0; idx--)
		{
			removeSelector(s[idx].id)
		}
	}
}

function onClickSystem(evt)
{
	if (!evt.currentTarget) evt.currentTarget = evt.srcElement;
	if (evt.ctrlKey && !evt.shiftKey)
	{
		closezoom = !closezoom;
		if (closezoom)
		{
			removeShifts();
			var idx = parseInt(evt.currentTarget.id);
			zoom = def_zoom;
			S.Center.Zoom(0.0);
			S.Dist = defaultDist*(Math.pow(0.8,5));
			zoomFactor = Math.pow(0.8,5);
			ShiftView((galArray[idx][1]-64-centre_x)*zoom - S.Center.x, (galArray[idx][0]-128-centre_y)*zoom - S.Center.y, (galArray[idx][2]-16-centre_z)*zoom - S.Center.z);
			redrawSelectors();
		}
		else
		{
			removeShifts();
			resetView();
			redrawSelectors();
		}
	}
	else selectSystem(evt);

}

function selectSystem(evt)
{
	//if (!evt.currentTarget) evt.currentTarget = evt.srcElement;
	var idx = parseInt(evt.currentTarget.id);
	var source = systems[idx];
	/*if (selectidxs.length > 0 && idx == selectidxs[0].id) 
	{
		removeSelector("select1");
		removeSelector("select2");
		selectidxs = [];
		resetTextBox("search1");
		resetTextBox("search2");
		removeRoute(selectidxs.length - 2);
		route = null;
		routeType = "distance";
		return;
	}*/
	if (evt.button == buttonLeft)
	{
		var size = selectSize * S.ScreenScale(source.Center);
		var screenPos = S.ScreenPos(source.Center);
		let selector;
		
		if ((evt.shiftKey) && (evt.ctrlKey) && (selectidxs.length > 0)) {
			let selectorSystems = selectidxs.map((e, i) => [i, e.id]).filter(e => e[1] === idx);
			if (selectorSystems.length > 0) selector = selectorSystems[selectorSystems.length - 1][0];
			else selector = null;
			if (selector !== null && selector < selectidxs.length - 1) {
				removeRoute(selector);
				selectidxs.map((e,i) => i).filter((e,i) => i > selector).forEach(e => removeSelector("select" + (e + 1)));
				selectidxs.splice(selector + 1);
				redrawSelectors();
			}
			if (selectidxs.length > 0) setTextBox("search1", galArray[selectidxs[selectidxs.length - 1].id][4].name);
			unlockTextBox("search1");
			if (selectidxs.length > 1) lockTextBox("search1");
			resetTextBox("search2");
			removeSearchResults("show");
		}
		if ((evt.shiftKey) && !evt.ctrlKey && (selectidxs.length > 0) && idx !== selectidxs[selectidxs.length-1].id)
		{
			let prevSysIdx = selectidxs[selectidxs.length-1].id;
			if (selectidxs.length > 0 && idx != prevSysIdx)
			{
				route = routeFromSystem(prevSysIdx, idx, routeType, galArray);
				if (route !== null) {
					selectidxs.push({id: idx, type: routeType, route: routeFromSystem(prevSysIdx, idx, routeType, galArray), shown: false});
				
					}	redrawSelectors();
					setTextBox("search1", galArray[idx][4].name);
					lockTextBox("search1");
					resetTextBox("search2");
					removeSearchResults("show");
			}
			else 
			{
				selectidxs.pop();
				redrawSelectors();
				unlockTextBox("search1");
				resetTextBox("search2");
				removeSearchResults("show");
			}
		}
		if (!evt.shiftKey && !evt.ctrlKey) {
			if (selectidxs.length === 0 || !(selectidxs.length === 1 && idx === selectidxs[0].id)) {
				removeRoute(0);
				selectidxs.map((e,i) => i).forEach(e => removeSelector("select" + (e + 1)));
				selectidxs.splice(0);
				selectidxs.push({id: idx, type: null, route: null, shown: false});
				redrawSelectors();
				routeType = "distance";
				setTextBox("search1", galArray[idx][4].name);
				resetTextBox("search2");
				removeSearchResults("show");
			}
			else {
				removeSelector("select1");
				selectidxs = [];
			}
		}
		if (selectidxs.length >= 2)
		{
			removeSelectorsByClassName("searchlist");
			redrawRoute();
			
		}
		else
		{
			removeRoute(0);
			route = null;
			routeType = "distance";
		}
	}
}

/*function mouseDownModifierCheck(evt)
{
	shiftkey = evt.shiftKey;
}*/

function redrawSelectors(list)
{
	var list2;
	if ( (list === null) || (list === undefined) || (list === "no route")) list2 = ["route", "search"];
	else list2 = list;
	
	if (list2.indexOf("route") > -1) {
		for (let i = 0; i < selectidxs.length; i++) {
			let size = selectSize * S.ScreenScale(systems[selectidxs[i].id].Center);
			let screenPos = S.ScreenPos(systems[selectidxs[i].id].Center);
			let styling;
			let selector = "select" + (i + 1);
			if (i === 0) {
				styling = "stroke:rgb(0,192,0);stroke-width:" + (2 * ZOOM);
			}
			else if (i === selectidxs.length - 1) {
				styling = "stroke:rgb(192,0,0);stroke-width:" + (2 * ZOOM);
			}
			else {
				styling = "stroke:rgb(160,32,240);stroke-width:" + (2 * ZOOM);
			}
			removeSelector(selector);
			addSelector(selector, selector, selectidxs[i].id, screenPos.x, screenPos.y, size, styling);
		}
	}


	if ((list !== "no route") && (selectidxs.length > 0) && (list2.indexOf("route") > -1) )
	{
		redrawRoute(); //displayRoute(route, routeType);
	}
	if ((searchList !== null) && (list2.indexOf("search") > -1))
	{
		removeSelectorsByClassName("searchlist");
		if (searchList.length > 1)
		{
			var source, size, screenPos;
			for(var idx = 0; idx < searchList.length; idx++)
			{
				source = systems[searchList[idx]];
				size = selectSize * S.ScreenScale(source.Center);
				screenPos = S.ScreenPos(source.Center);
				addSelector("searchselector"+idx, "searchlist", searchList[idx], screenPos.x, screenPos.y, size, "stroke:rgb(255,140,0);stroke-width:2");
			}
		}
	}
}

function redrawRoute()
{
	//if ((inRouteType !== null) && (inRouteType !== undefined)) routeType = inRouteType;
	
	if (route !== null)
	{
		removeRoute(0);
		route = null;
	}
	selectidxs.filter((e,i) => i > 0)
		.forEach((e,i) => {
			let routeType = e.type;
			route = routeFromSystem(selectidxs[i].id, e.id, routeType, galArray);
			displayRoute(i, route, routeType);
		});
}

function displayRoute(routeidx, route, routeType)
{
	if (route === null) return;
	var colour;
	if (routeType == "distance") colour = "#ff00ff";
	else colour = "#00ffff";
	var width;
	
	selectidxs[routeidx + 1].shown = true;
	for(var idx = 0; idx < (route[0].length - 1); idx++)
	{
		var li;
		if (route[0][idx] < route[0][idx+1]) li = svgRoot.getElementById("Line-"+route[0][idx]+"-"+route[0][idx+1]);
		else li = svgRoot.getElementById("Line-"+route[0][idx+1]+"-"+route[0][idx]);

		let overlapCount = parseInt(li.getAttribute("count"), 10) || 1;
		overlapCount++;

		li = li.getElementsByTagName("path")[0];
		li.setAttribute("route-index", routeidx);
		li.setAttribute("stroke", colour);
		li.setAttribute("count", overlapCount);
		width = lineWidth * (overlapCount * 2 - 1);
		li.setAttribute("stroke-width", width);
		li.setAttribute("onclick", "parent.swapRouteType(evt)");
	}

	displayRouteDetails();
	
}

function removeRoute(routeidx)
{
	if (selectidxs.length === 0) return;
	for (let ri = routeidx + 1; ri < selectidxs.length; ri++) {
		if (selectidxs[ri].shown) {
			let route = selectidxs[ri].route; 

			for(let idx = 0; idx < (route[0].length - 1); idx++)
			{
				let li;
				if (route[0][idx] < route[0][idx+1]) li = svgRoot.getElementById("Line-"+route[0][idx]+"-"+route[0][idx+1]);
				else li = svgRoot.getElementById("Line-"+route[0][idx+1]+"-"+route[0][idx]);
				
				li = li.getElementsByTagName("path")[0];
				li.removeAttribute("route-index");
				
			
				
				li.setAttribute("stroke", baseLineColour);
				//li.removeAttribute("stroke-backup");
				
				let overlapCount = parseInt(li.getAttribute("count"), 10) || 1;
				overlapCount--;
				width = lineWidth * (overlapCount * 2 - 1);
				li.setAttribute("stroke-width", width);
				
				li.removeAttribute("stroke-width-backup");
				li.removeAttribute("onclick");
				
				
			}
			selectidxs[ri].shown = false;
		}
	}
	removeRouteDetails();
}

function swapRouteType(evt)
{
	if (routeType == "distance") routeType = "time";
	else routeType = "distance";
	let index = parseInt(evt.currentTarget.getAttribute("route-index"), 10);
	removeRoute(index);
	selectidxs[index + 1].type = routeType;
	selectidxs[index + 1].route = routeFromSystem(selectidxs[index].id, selectidxs[index + 1].id, routeType, galArray);
	redrawRoute(); //displayRoute(route, routeType);
}

function displayRouteDetails()
{
	removeRouteDetails();

	var routedetailsgroup = svgDoc.createElementNS("http://www.w3.org/2000/svg", "g");
	routedetailsgroup.className = "routedetails";
	routedetailsgroup.id = "routedetails";
	routedetailsgroup.setAttribute("transform", "translate(" + CLIPLEFT + " " + (CLIPBOTTOM+30) + ")");
	routedetailsgroup.setAttribute("visibility", "visible");
	routedetails = svgDoc.createElementNS("http://www.w3.org/2000/svg", "text");
	routedetails.className = "routedetails";
	routedetails.id = "routedetailstext";
	
	routedetails.setAttribute("style", "font-family: sans-serif;font-size: 14pt");
	svgRoot.appendChild(routedetailsgroup);
	routedetailsgroup.appendChild(routedetails);

	var routeText = "";
	routeTextArr = [];
	selectidxs.forEach((e,i) => {
		let end_style = (i === selectidxs.length - 1) ? "end-route" : "waypoint-route";
		if (i === 0) {
			routeTextArr.push("<tspan class=\"start-route\">" + galArray[e.id][4].name.toProperCase() + "</tspan>");
		}
		else {
			let route = e.route[0].filter((e, i, a) => i > 0 && i < a.length - 1).forEach(s => routeTextArr.push("<tspan class=\"" + e.type + "-route\">" + galArray[s][4].name.toProperCase() + "</tspan>"));
			routeTextArr.push("<tspan class=\"" + end_style + "\">" + galArray[e.route[0][e.route[0].length-1]][4].name.toProperCase() + "</tspan>");
		}
	});
	routeText = routeTextArr.join(", ");
	
	/*
	for(var idx = 0; idx < route[0].length; idx++)
	{
		if (idx != 0) routeText += ", ";
		routeText += galArray[route[0][idx]][4].name.toProperCase();
	}*/

	var ts;
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "route-header";
	ts.setAttribute("style", "font-weight: normal;fill: white");
	ts.setAttribute("x", 0);
	ts.innerHTML = "Route (Key: <tspan class=\"start-route\">Start</tspan>, <tspan class=\"distance-route\">Shortest Route</tspan>, <tspan class=\"waypoint-route\">Waypoint</tspan>, <tspan class=\"time-route\">Quickest Route</tspan>, <tspan class=\"end-route\">End</tspan>):";
	routedetails.appendChild(ts);

	var routeTextArray = wrapText(routeText, (CLIPRIGHT-CLIPLEFT), "font-family: sans-serif;font-size: 14pt;font-weight: normal", 0);
	for (var z = 0; z < routeTextArray.length; z++)
	{
		ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
		ts.id = "route-" + z;
		if (z == 0)
		{
			ts.setAttribute("x", 0);
			ts.setAttribute("dy", "30");
		}
		else 
		{
			ts.setAttribute("x", "0");
			ts.setAttribute("dy", "20");
		}
		ts.setAttribute("style", "font-weight: normal;fill: yellow");
		ts.innerHTML = routeTextArray[z];
		routedetails.appendChild(ts);
	}

	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "route-footer";
	ts.setAttribute("style", "font-weight: normal;fill: white");
	ts.setAttribute("x", 0);
	ts.setAttribute("dy", "30");
	ts.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
	ts.textContent = "Jumps: " + selectidxs.filter((e, i) => i > 0).map(e => e.route[0].length-1).reduce((a,c) => a + c) + "   Distance: " + selectidxs.filter((e, i) => i > 0).map(e => e.route[1]).reduce((a,c) => a + c).toFixed(1) + " lyrs   Time: " + selectidxs.filter((e, i) => i > 0).map(e => e.route[2]).reduce((a,c) => a + c).toFixed(2) + " hrs";
	routedetails.appendChild(ts);
}

function removeRouteDetails()
{
	var n = svgRoot.getElementById("routedetails");
	if (n !== null) n.parentNode.removeChild(n);
}

function displaySearchResults(name)
{
	var box = document.getElementById(name);
	if (box === null) return;

	removeSearchResults("no unhide");

	//hide route details if displayed
	hideElement("routedetailstext");

	var searchresultsgroup = svgDoc.createElementNS("http://www.w3.org/2000/svg", "g");
	searchresultsgroup.className = "searchresults";
	searchresultsgroup.id = "searchresults";
	searchresultsgroup.setAttribute("transform", "translate(" + CLIPLEFT + " " + (CLIPBOTTOM+30) + ")");
	searchresultsgroup.setAttribute("visibility", "visible");
	searchresults = svgDoc.createElementNS("http://www.w3.org/2000/svg", "text");
	searchresults.className = "searchresults";
	searchresults.id = "searchresultstext";
	
	searchresults.setAttribute("style", "font-family: sans-serif;font-size: 14pt");
	svgRoot.appendChild(searchresultsgroup);
	searchresultsgroup.appendChild(searchresults);

	var searchResultsText = "";
	for(var idx = 0; idx < searchList.length; idx++)
	{
		if (idx != 0) searchResultsText += ", ";
		searchResultsText += galArray[searchList[idx]][4].name.toProperCase();
	}

	var ts;
	
	ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
	ts.id = "searchresults-header";
	ts.setAttribute("style", "font-weight: normal;fill: white");
	ts.setAttribute("x", 0);
	ts.textContent = "Systems Starting '" + box.value.toProperCase() + "':";
	searchresults.appendChild(ts);

	var searchResultsArray = wrapText(searchResultsText, (CLIPRIGHT-CLIPLEFT), "font-family: sans-serif;font-size: 14pt;font-weight: normal", 0);
	for (var z = 0; z < searchResultsArray.length; z++)
	{
		ts = svgDoc.createElementNS("http://www.w3.org/2000/svg", "tspan");
		ts.id = "searchresults-" + z;
		if (z == 0)
		{
			ts.setAttribute("x", 0);
			ts.setAttribute("dy", "30");
		}
		else 
		{
			ts.setAttribute("x", "0");
			ts.setAttribute("dy", "20");
		}
		ts.setAttribute("style", "font-weight: normal;fill: yellow");
		ts.textContent = searchResultsArray[z];
		searchresults.appendChild(ts);
	}
}

function removeSearchResults(method)
{
	var n = svgRoot.getElementById("searchresults");
	if (n !== null) n.parentNode.removeChild(n);

	//show route details if they exist.
	if (method == "show") showElement("routedetailstext");

}

function hideElement(name)
{
	var n = svgRoot.getElementById(name);
	if (n !== null) n.setAttribute("visibility", "hidden");
}

function showElement(name)
{
	var n = svgRoot.getElementById(name);
	if (n !== null) n.setAttribute("visibility", "visible");
}

function popup(mylink, windowname)
{
	//code from http://www.htmlcodetutorial.com/linking/linking_famsupp_72.html
	if (! window.focus)return true;
	var href;
	if (typeof(mylink) == 'string') href=mylink;
	else href=mylink.href;
	window.open(href, windowname, 'left=200,top=150,width=900,height=600,scrollbars=yes');
	return false;
}

String.prototype.toProperCase = function () 
{
	//code from http://stackoverflow.com/questions/196972/convert-string-to-title-case-with-javascript
	return this.replace(/\w\S*/g, function(txt){return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();});
};

function getCheckedRadioValue(groupName)
{
	var list = document.getElementsByName(groupName);
	for (var idx = 0; idx < list.length; idx++)
	{
		if (list[idx].checked) return list[idx].value;
	}
}

function resetRadiobuttons(groupName)
{
	var list = document.getElementsByName(groupName);
	for (var idx = 0; idx < list.length; idx++)
	{
		list[idx].checked = false;
		if (list[idx].hasAttribute("checked")) list[idx].checked = true;
	}
}

function resetTextBox(name)
{
	var box = document.getElementById(name);
	if (box === null) return;
	if (box.hasAttribute("type"))
	{
		if (box.type == "text") box.value = "";
	}
}

function setTextBox(name, invalue)
{
	var box = document.getElementById(name);
	if (box === null) return;
	if (box.hasAttribute("type"))
	{
		if (box.type == "text") box.value = invalue;
	}
}

function lockTextBox(name) {
	var box = document.getElementById(name);
	if (box === null) return;
	box.disabled = true;
}

function unlockTextBox(name) {
	var box = document.getElementById(name);
	if (box === null) return;
	box.disabled = false;
}

function searchSystems(name)
{
	var box = document.getElementById(name);
	if (box === null) return;
	if (box.hasAttribute("type"))
	{
		if (box.type == "text")
		{
			//selectidx1 = null;
			//selectidx2 = null;
			//redrawSelectors();
			removeSearchResults("show");
			if ((name == "search2") && (selectidxs.length === 0))
			{
				resetTextBox("search2");
				//removeSearchResults();
				return;
			}
			removeSelectorsByClassName("searchlist");
			if (box.value.length > 0)
			{
				searchList = searchSystemsInfo("name", box.value);
				//alert(JSON.stringify(searchList));
				if (searchList.length == 0)
				{
					if (box.getAttribute("style").indexOf("color: red;") == -1)
					{
						box.setAttribute("style-backup", box.getAttribute("style"));
						box.setAttribute("style", box.getAttribute("style") + "color: red;");
					}
				}
				else
				{
					if (box.hasAttribute("style-backup"))
					{
						box.setAttribute("style", box.getAttribute("style-backup"));
						box.removeAttribute("style-backup");
					}
				}
				if (searchList.length == 1)
				{
					removeRoute(route);
					let search1Offset = (selectidxs.length >= 2) ? selectidxs.length - 2 : 0;
					let search2Offset = (selectidxs.length >= 2) ? selectidxs.length - 1 : 1;
					if (name == "search1") {
						if (search1Offset === 0) {
							selectidxs[0] = {id: searchList[0], type: null, route: null, shown: false};
						}
						else {
							let prevSysIdx = selectidxs[selectidxs.length-1].id;
							let route = routeFromSystem(prevSysIdx, searchList[0], routeType, galArray);
							selectidxs.push({id: searchList[0], type: routeType, route: route, shown: false});
						}
						setTextBox("search1", galArray[selectidxs[selectidxs.length - 1].id][4].name);
					}
					if (name == "search2") {
						let prevSysIdx = selectidxs[selectidxs.length-1].id;
						let route = routeFromSystem(prevSysIdx, searchList[0], routeType, galArray);
						selectidxs.push({id: searchList[0], type: routeType, route: route, shown: false});
						setTextBox("search1", galArray[selectidxs[selectidxs.length - 1].id][4].name);
						resetTextBox("search2");
						lockTextBox("search1");
					}
					redrawSelectors(["route"]);
					if (selectidxs.length >= 2) redrawRoute();
				}
				if (searchList.length > 1)
				{
					redrawSelectors(["search"]);
					displaySearchResults(name);
				}
			}
		}
	}
}

function exitSearch(name)
{
	let search1Offset = (selectidxs.length >= 2) ? selectidxs.length - 1 : 0;
	if ((name == "search1") && (selectidxs[search1Offset]))
	{
		setTextBox(name, galArray[selectidxs[search1Offset].id][4].name);
		removeSelectorsByClassName("searchlist");
		removeSearchResults("show");
	}
	if (name == "search2")
	{
		resetTextBox(name);
		removeSelectorsByClassName("searchlist");
		removeSearchResults("show");
		document.getElementById("search1").focus();
	}
}

function moveOverlapping(evt)
{
	if (galOverlaps.length == 0) return;

	var x, y;
	if (evt.layerX || evt.layerX == 0) // from http://dev.opera.com/articles/view/html5-canvas-painting/
	{ // Firefox
		x = evt.layerX;
		y = evt.layerY;
	}
	else if (evt.offsetX || evt.offsetX == 0) 
	{ // Opera
		x = evt.offsetX;
		y = evt.offsetY;
	} //end of code from http://dev.opera.com/articles/view/html5-canvas-painting/

	//x -= ma_offset_x;
	//y -= ma_offset_y;

	var tb = document.getElementById("coords");
	var source, xpos, ypos, dist2, dist;
	var shiftBool = false;
 
	for (var idx = 0; idx < galOverlaps.length; idx++)
	{
		source = systems[galOverlaps[idx][0][0]];
		xpos = S.ScreenPos(source.Center).x;
		ypos = S.ScreenPos(source.Center).y;
		dist2 = (xpos-x)*(xpos-x) + (ypos-y)*(ypos-y);
	
		dist = Math.sqrt(dist2);

		if (dist < (sepStart/zoomFactor))
		{
			shiftBool = true;

			var sepDist;
			if (dist < (sepFinish/zoomFactor)) sepDist = (separation/zoomFactor);
			else sepDist = ((sepStart/zoomFactor) - dist) / ((sepStart/zoomFactor) - (sepFinish/zoomFactor)) * (separation/zoomFactor);

			for (var idx2 = 0; idx2 < galOverlaps[idx][0].length; idx2++)
			{
				var angle;
				if (!DRAW3D)
				{
					angle = galOverlaps[idx][2] + (2 * Math.PI / galOverlaps[idx][0].length * idx2);
				}
				else
				{
					var s = galOverlaps[idx][0].slice(0) // duplicate
					var pos = s.indexOf(galOverlaps[idx][3]);
					if (pos > -1) s.splice(pos, 1);
					s.sort();
					angle =  -(Math.PI/2) + (2 * Math.PI / galOverlaps[idx][0].length * (s.indexOf(galOverlaps[idx][0][idx2]) + 1));
				}
				var dx, dy;
				dx = Math.cos(angle) * sepDist;
				dy = Math.sin(angle) * sepDist;

				//Shift Systems
				var s = svgDoc.getElementById(galOverlaps[idx][0][idx2]);
				s.setAttribute("transform", "translate(" + dx + " " + dy + ")");
				galOffsets[galOverlaps[idx][0][idx2]][0] = dx;
				galOffsets[galOverlaps[idx][0][idx2]][1] = dy;
				
				//Shift System Links starting with index
				var lines = svgDoc.evaluate("//*[starts-with(@id, 'Line-" + galOverlaps[idx][0][idx2] + "-')]", svgDoc, svgResolver, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
				for (var line = 0; line < lines.snapshotLength; line++)
				{
					var parentElement = svgDoc.getElementById(lines.snapshotItem(line).id);
					var element = parentElement.getElementsByTagName("path")[0];
					if (!element.hasAttribute("d-backup")) element.setAttribute("d-backup", element.getAttribute("d"));
					if (!element.hasAttribute("overlapid")) element.setAttribute("overlapid", idx);
					var ps = getPathSegment(element, "d-backup", 0);
					if (ps === null) alert("id=" + lines.snapshotItem(line).id + " d=" + element.getAttribute("d"));
					var pss = ps.split(" ");
					if (pss[0] == "M")
					{
						var x = parseInt(pss[1]);
						var y = parseInt(pss[2]);
						
						var newPath = "M " + (x + dx) + " " + (y + dy) + " ";
						setPathSegment(element, "d", 0, newPath);
					}
				}
				//Shift System Links ending with index;
				var lines = svgDoc.evaluate("//*[starts-with(@id,'Line-') and substring(@id, string-length(@id) - string-length('" + galOverlaps[idx][0][idx2] + "')) = '-" + galOverlaps[idx][0][idx2] + "']", svgDoc, svgResolver, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
				for (var line = 0; line < lines.snapshotLength; line++)
				{
					var parentElement = svgDoc.getElementById(lines.snapshotItem(line).id);
					var element = parentElement.getElementsByTagName("path")[0];
					if (!element.hasAttribute("d-backup")) element.setAttribute("d-backup", element.getAttribute("d"));
					if (!element.hasAttribute("overlapid")) element.setAttribute("overlapid", idx2);
					var ps = getPathSegment(element, "d-backup", 1);
					var pss = ps.split(" ");
					if (pss[0] == "L")
					{
						var x = parseInt(pss[1]);
						var y = parseInt(pss[2]);
						
						var newPath = "L " + (x + dx) + " " + (y + dy) + " ";
						setPathSegment(element, "d", 1, newPath);
					}
				}
			}
		}
		else
		{
			//Remove Shift
			for (var idx2 = 0; idx2 < galOverlaps[idx][0].length; idx2++)
			{
				//Systems Shift

				var s = svgDoc.getElementById(galOverlaps[idx][0][idx2]);
				if (s.hasAttribute("transform"))
				{
					s.removeAttribute("transform");
					shiftBool = true;
				}
				galOffsets[galOverlaps[idx][0][idx2]][0] = 0;
				galOffsets[galOverlaps[idx][0][idx2]][1] = 0;

				//Line Shifts
				var lineShifts = svgDoc.evaluate("//*[@overlapid]", svgDoc, svgResolver, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
				for (var idx3 = 0; idx3 < lineShifts.snapshotLength; idx3++)
				{
					var parentElement = svgDoc.getElementById(lineShifts.snapshotItem(idx3).parentNode.id);
					var element = parentElement.getElementsByTagName("path")[0];
					if (element.getAttribute("overlapid") == idx)
					{
						element.setAttribute("d", element.getAttribute("d-backup"));
						element.removeAttribute("d-backup");
						element.removeAttribute("overlapid");
					}
				}

			}

		}
	}
	if (shiftBool)
	{
		redrawSelectors("no route");
	}
}

function getPathSegment(element, pathAttrib, pathSegmentNum)
{
	var path;
	if (element.hasAttribute(pathAttrib)) path = element.getAttribute(pathAttrib);
	else return null;
	var segments = normalisePathSegments(path, "array");
	if (segments === null) return null;
	if (pathSegmentNum > (segments.length - 1)) return null;
	return segments[pathSegmentNum];
}

function getPathSegmentCount(element, pathAttrib)
{
	var path;
	if (element.hasAttribute(pathAttrib)) path = element.getAttribute(pathAttrib);
	else return null;
	var segments = normalisePathSegments(path, "array");
	if (segments === null) return null;
	return segments.length;
}

function setPathSegment(element, pathAttrib, pathSegmentNum, value)
{
	var path, path2 = "";
	if (element.hasAttribute(pathAttrib)) path = element.getAttribute(pathAttrib);
	else return;
	var segments = normalisePathSegments(path, "array");
	if (segments === null) return;
	if (pathSegmentNum > (segments.length - 1)) return;
	segments[pathSegmentNum] = value;
	for (var idx = 0; idx < segments.length; idx++)
	{
		path2 += segments[idx] + " ";
	}
	path2 = normalisePathSegments(path2);
	element.setAttribute(pathAttrib, path2);
}

function normalisePathSegments(path, returnType)
{
	var path2 = path.concat("");
	var pathCommands =[["M", 2],["m", 2],["Z", 0],["z", 0],["L", 2],["l", 2],["H", 1],["h", 1],["V", 1],["v", 1],["C", 6],["c", 6],["S", 4],["s", 4],["Q", 4],["q", 4],["T", 2],["t", 2],["A", 7],["a", 7]];
	var segments = [];
	var newPath = "";

	function getPathCommandArgRepeat(command)
	{
		for(var idx = 0; idx < pathCommands.length; idx++)
		{
			if (pathCommands[idx][0] == command) return pathCommands[idx][1];
		}
		return null;
	}

	for (var pc = 0; pc < pathCommands.length; pc++)
	{
		path2 = stringReplaceAll(path2, pathCommands[pc][0], pathCommands[pc][0] + " ");
	}
	path2 = path2.replace(/,/g, " ");
	path2 = path2.replace(/\ +/g, " ");
	while(true)
	{
		var matchStr = path2.match(/^[MmZzLlHhVvCcSsQqTtAa]{1}[0-9. ]*/);
		if (matchStr === null) break;
		var segType = matchStr[0].substr(0,1);
		var matchStr2 = matchStr[0].substr(2).match(/[0-9.]*\s/g);
		if (matchStr2 === null) matchStr2 = [];
		argRepeats = getPathCommandArgRepeat(segType)
		if (argRepeats === null) return null;
		if ((argRepeats == 0) && (matchStr2.length > 0)) return null;
		if (argRepeats == 0) 
		{
			segments.push(segType);
			newPath += segType;
		}
		else
		{
			if ((matchStr2.length % argRepeats) != 0) return null;
			var segCount = 0;
			for (var idx = 0; idx < Math.floor(matchStr2.length / argRepeats); idx++)
			{
				var segment = segType + " ";
				for (var idx2 = 0; idx < argRepeats; idx++)
				{
					segment += matchStr2[segCount];
					segCount++;
				}
				segments.push(segment);
				newPath += segment;
			}
		}
		path2 = path2.substr(matchStr[0].length);
		if (path2.length == 0) break;
	}
	if (returnType == "array") return segments;
	else return newPath;
}

function removeShifts()
{
	for (var idx = 0; idx < galOverlaps.length; idx++)
	{
		for (var idx2 = 0; idx2 < galOverlaps[idx][0].length; idx2++)
		{
			//Systems Shift
			var s = svgDoc.getElementById(galOverlaps[idx][0][idx2]);
			if (s.hasAttribute("transform"))
			{
				s.removeAttribute("transform");
				shiftBool = true;
			}
			galOffsets[galOverlaps[idx][0][idx2]][0] = 0;
			galOffsets[galOverlaps[idx][0][idx2]][1] = 0;

			//Line Shifts
			var lineShifts = svgDoc.evaluate("//*[@overlapid]", svgDoc, svgResolver, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
			for (var idx3 = 0; idx3 < lineShifts.snapshotLength; idx3++)
			{
				var parentElement = svgDoc.getElementById(lineShifts.snapshotItem(idx3).parentNode.id);
				var element = parentElement.getElementsByTagName("path")[0];
				if (element.getAttribute("overlapid") == idx)
				{
					element.setAttribute("d", element.getAttribute("d-backup"));
					element.removeAttribute("d-backup");
					element.removeAttribute("overlapid");
				}
			}
		}
	}
}

function hideInput(id)
{
	var b = document.getElementById(id);
	if (b !== null)
	{
		if (b.nodeName.toUpperCase() == "INPUT")
		{
			b.style.visibility="hidden";
			b.style.display="none";
		}
	}
}

function showInput(id)
{
	var b = document.getElementById(id);
	if (b !== null)
	{
		if (b.nodeName.toUpperCase() == "INPUT")
		{
			b.style.visibility="visible";
			b.style.display="";
		}
	}
}

function toggle3D()
{
	if (DRAW3D)
	{
		showInput("rotateleft");
		showInput("rotateright");
		showInput("rotateup");
		showInput("rotatedown");
	}
	else
	{
		hideInput("rotateleft");
		hideInput("rotateright");
		hideInput("rotateup");
		hideInput("rotatedown");
	}
}


function change_visibility(id_str)
{
	if (document.getElementById(id_str).style.visibility=="hidden") document.getElementById(id_str).style.visibility="visible";
	else document.getElementById(id_str).style.visibility="hidden";
}

function setSeedTextBoxes(seeds)
{
	for(var i = 0; i < 6; i++)
	{
		document.getElementById("seed_" + String.fromCharCode(97 + i)).value = seeds[i];
	}
}

function toggle_galaxy_seeds_dialog()
{
	setSeedTextBoxes(current_seeds);
	change_visibility('galaxy_seed');
	if (pageFreeze["galaxy_seed"]) enablePage();
	else 
	{
		disablePage(1);
		setSelected();
		document.getElementById("apply_seed").disabled = true;
	}
	pageFreeze["galaxy_seed"] = !pageFreeze["galaxy_seed"];
}

function validateSeed(id_str)
{
	var i = id_str.charCodeAt(5) - 97;
	var v = document.getElementById(id_str).value;
	if (isNaN(parseInt(v))) 
	{
		document.getElementById(id_str).value = current_seeds[i];
		return;
	}
	else
	{
		v = parseInt(v);
		document.getElementById(id_str).value = v;
		if (v < 0 || v > 255)
		{
			document.getElementById(id_str).value = current_seeds[i];
			return;
		}
	}
}

function setDefaultSeed()
{
	current_seeds=init_seeds.slice(0);
	setSeedTextBoxes(current_seeds);
}

function applySeed(mode)
{
	if (mode == 1)
	{
		for(var i = 0; i < 6; i++)
		{
			current_seeds[i] = parseInt(document.getElementById("seed_" + String.fromCharCode(97 + i)).value);
		}
	}
	toggle_galaxy_seeds_dialog();
	toggle3D();
	resetRadiobuttons("galaxy");
	resetRadiobuttons("mode");
	ChangeGalaxy();
}

function setSeed(seed)
{
	current_seeds = seed.slice(0);
	setSeedTextBoxes(current_seeds);
	toggle_galaxy_seeds_dialog();
	toggle3D();
	resetRadiobuttons("galaxy");
	resetRadiobuttons("mode");
	ChangeGalaxy();
}

function disablePage(z_order)
{
	
	if (!blurDiv)
	{
		blurDiv = document.createElement("div");
		blurDiv.id = "blurDiv"; 
		blurDiv.style.cssText = "position:absolute; top:0; right:0; width:" + screen.width + "px; height:" + screen.height + "px; background-color: #000000; opacity:0.5; filter:alpha(opacity=50); z-index: " + z_order + ";";
		blurDiv.setAttribute("onclick", "toggle_galaxy_seeds_dialog()");
		document.getElementsByTagName("body")[0].appendChild(blurDiv);
	}
	else
	{
		blurDiv.style.cssText = blurDiv.style.cssText.replace(/z-index:[^;]*;/, "z-index: " + z_order + ";");
	}

	blurStack.push(z_order);
}

function enablePage()
{
	blurDiv = document.getElementById("blurDiv");
	
	if (blurStack.length == 1)
	{
 		document.getElementById("blurDiv").remove();
		blurDiv = null;
		blurStack.pop();
	}
	else
	{
		blurStack.pop();
		blurDiv.style.cssText = blurDiv.style.cssText.replace(/z-index:[^;]*;/, "z-index: " + blurStack[blurStack.length - 1].toString() + ";");
	}
}

function supports_html5_storage() 
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null;
  } catch (e) {
    return false;
  }
}

function setupGalaxyList(populateLevel)
{
	if (supports_html5_storage())
	{
		var el = document.getElementById("default_seed");
		if (el) el.parentNode.removeChild(el);

		if (populateLevel > 0) populateComboList(populateLevel);		
	
		var combobox = document.getElementById("seed_store");		

		while (combobox.firstChild)
		{
			combobox.removeChild(combobox.firstChild);
		}

		for (var i = 0; i < comboList.length; i++)
		{
			var entry = comboList[i][0];
			if (entry == "")
			{
				combobox.options[combobox.options.length] = new Option(entry, "");
				var opt = combobox.options[combobox.options.length - 1];
				opt.setAttribute("disabled", "disabled");
				opt.setAttribute("class", "SelectSeparator");
			}
			else
			{
				combobox.options[combobox.options.length] = new Option(entry, entry);
			}
		}
	}
	else
	{
		var el = document.getElementById("seed_store");
		if (el) el.parentNode.removeChild(el);
	}
}

function populateComboList(populateLevel)
{
	if (populateLevel >= 3)
	{
		var galListStr = localStorage["galaxyList"];
	
		if (galListStr !== null && galListStr !== undefined)
		{
			if (galListStr.length > 0)
			{
				galList = JSON.parse(galListStr);
				galList.sort(function(a, b) { if (a[0] > b[0]) return 1; if (a[0] < b[0]) return -1; return 0; });
			}
		}
		
	}
	
	if (populateLevel >= 2) comboList = [["Oolite Default",init_seeds]];

	if (galList.length >= 1)
	{
		for (var i = 0; i < comboList.length; i++)
		{
			if (comboList[i][0] == "") 
			{
				alert("List Duplication!!");
				break;
			}
		}
		comboList.push(["", null]);
		comboList = comboList.concat(galList);
	}
}

function addDeleteSaveComboListEntry(type_str)
{
	//delete the Save or Delete and Rename Options
	var i = 0;
	while (i < comboList.length)
	{
		if (comboList[i][0] == "") 
		{
			break;
		}
		if (comboList[i][1] === null) comboList.splice(i,1);
		else i++;
	}

	var cond = (i == comboList.length);

	if (type_str == "Delete")
	{
		//add the Rename option
		if (cond) comboList.push(["Rename Galaxy Seed", null]);
		else comboList.splice(i, 0, ["Rename Galaxy Seed", null]);
		//add the Delete option
		if (cond) comboList.push(["Delete Galaxy Seed", null]);
		else comboList.splice(i+1, 0, ["Delete Galaxy Seed", null]);
	}
	if (type_str == "Save")
	{
		//add the Other option
		if (cond) comboList.push(["Other Galaxy Seed", null]);
		else comboList.splice(i, 0, ["Other Galaxy Seed", null]);
		//add the Save
		if (cond) comboList.push(["Save Galaxy Seed", null]);
		else comboList.splice(i+1, 0, ["Save Galaxy Seed", null]);
	}
}

function setSelected()
{
	var seedName;
	var idx = null;

	if (current_seed_name === null) seedName = "Other Galaxy Seed";
	else seedName = current_seed_name;
	//alert("seedName=" + seedName);
	var combobox = document.getElementById("seed_store");
	combobox.value = seedName;
	
/*
	for (var i = 0; i < combobox.options.length; i++)
	{
		alert("" + i + ": value=" + combobox.options[i].value);
		if (combobox.options[i].value = seedName) idx = i;
		combobox.options[i].selected = false;
	}

	if (idx !== null) combobox.options[idx].selected = true;*/
	
}

function setSeedTitle()
{
	var title;
	if (current_seed_name === null) title = "";
	else title = current_seed_name;
	document.getElementById("seed_title").firstChild.nodeValue = title;
}

function searchSeedList(seed)
{
	if (seed.equals(init_seeds)) return "Oolite Default";

	if (seed.length == 0) return null;

	for (var i = 0; i < galList.length; i++)
	{
		if (seed.equals(galList[i][1])) return galList[i][0];
	}

	return null;
}

function getSeed(seedName)
{
	if (seedName == "Oolite Default") return init_seed;

	if (galList.length == 0) return null;

	var i;
	for (i = 0; i < galList.length; i++)
	{
		if (seedName == galList[i][0]) return galList[i][1];
	}

	return null;
}

function deleteSeed(seedName)
{
	if (seedName == "Oolite Default") return;

	if (galList.length == 0) return;

	var i;
	for (i = 0; i < galList.length; i++)
	{
		if (seedName == galList[i][0]) break;
	}

	galList.splice(i,1);
	update_LS_galList();
	if (seedName == current_seed_name) current_seed_name = null;
}

function renameSeed(oldSeedName,newSeedName)
{
	if (seedName == "Oolite Default") return;

	if (galList.length == 0) return;

	var i;
	for (i = 0; i < galList.length; i++)
	{
		if (seedName == galList[i][0]) break;
	}

	galList.splice(i,1);
	update_LS_galList();
	if (seedName == current_seed_name) current_seed_name = null;
}


function changeGalaxyList(optionSelected)
{
	var seeds = null;
	if (optionSelected == "Oolite Default") 
	{
		//seeds = init_seeds;
		setSeed(init_seeds);
		current_seed_name = optionSelected;
		addDeleteSaveComboListEntry("None");
		setupGalaxyList(0);
		setSeedTitle();
	}
	else if (optionSelected == "Save Galaxy Seed")
	{
		toggle_save_seed_dialog("Save");
		//addDeleteSaveComboListEntry("Delete");
		//setupGalaxyList(0);
		//setSelected();
	}
	else if (optionSelected == "Delete Galaxy Seed")
	{
		deleteSeed(current_seed_name);
		
		//setSeed(getSeed("Oolite Default"));
		comboList = [["Oolite Default",init_seeds]];
		addDeleteSaveComboListEntry("Save");
		setupGalaxyList(1);
		//applySeed(1);
		setSelected();
		setSeedTitle();
	}
	else if (optionSelected == "Rename Galaxy Seed")
	{
		toggle_save_seed_dialog("Rename");
	}
	else
	{
		setSeed(getSeed(optionSelected));
		addDeleteSaveComboListEntry("Delete");
		setupGalaxyList(0);
		current_seed_name = optionSelected;
		setSeedTitle();
	}
}

function checkSeed()
{
	current_seed_name = searchSeedList(current_seeds);
	if (current_seed_name === null) addDeleteSaveComboListEntry("Save");
	else if (current_seed_name != "Oolite Default") addDeleteSaveComboListEntry("Delete");
	else addDeleteSaveComboListEntry("None");
	setupGalaxyList(0);
	setSelected();
	setSeedTitle();
}

function toggle_save_seed_dialog(mode)
{
	if (mode == "Save")
	{
		document.getElementById("seed_name").value = "";
		document.getElementById("seed_name_save").disabled=true;
	}
	else if (mode == "Rename") 
	{
		document.getElementById("seed_name").value = current_seed_name;
		document.getElementById("seed_name_save").disabled=true;
	}
	save_button_disabled = document.getElementById("seed_name_save").disabled;
	change_visibility("save_seed");
	if (pageFreeze["save_seed"]) enablePage();
	else disablePage(3);
	pageFreeze["save_seed"] = !pageFreeze["save_seed"];
}

function setAttrib(id_str, attrib_str, value_str)
{
	var e = document.getElementById(id_str);
	e.setAttribute(attrib_str, value_str);
}

function save_exit()
{
	toggle_save_seed_dialog("Reset");
	setSelected();
}

function checkSeedName(seedName)
{
	var idx = -1;

	for (var i = 0; i < comboList.length; i++)
	{
		if (comboList[i][0] == seedName)
		{
			idx = i;
			break;
		}
	}

	if (idx > -1 || seedName.length == 0) 
	{
		if (!save_button_disabled) 
		{
			document.getElementById("seed_name_save").disabled=true;
			save_button_disabled = true;
		}
	}
	else 
	{
		if (save_button_disabled)
		{
			document.getElementById("seed_name_save").disabled=false;
			save_button_disabled = false;
		}
	}
}

function saveSeed()
{
	var seedName = document.getElementById("seed_name").value;

	var renameId = -1;

	for (var i = 0; i < galList.length; i++)
	{
		if (current_seed_name == galList[i][0]) 
		{
			renameId = i;
			break;
		}
	}

	if (renameId > -1)
	{
		galList[renameId][0] = seedName;
	}
	else
	{
		galList.push([seedName, current_seeds.slice(0)]);
	}
	galList.sort(function(a, b) { if (a[0] > b[0]) return 1; if (a[0] < b[0]) return -1; return 0; });
	current_seed_name = seedName;
	comboList = [["Oolite Default",init_seeds]];
	addDeleteSaveComboListEntry("Delete");
	setupGalaxyList(1);

	update_LS_galList();
	toggle_save_seed_dialog("Reset");
	setSelected();
	toggle_galaxy_seeds_dialog();
	setSeedTitle();
}

function update_LS_galList()
{
	localStorage["galaxyList"] = JSON.stringify(galList);
}

function checkSeedIsDiff()
{
	var flag = true;
	for(var i = 0; i < 6; i++)
	{
		if (document.getElementById("seed_" + String.fromCharCode(97 + i)).value != current_seeds[i]) flag = false;

	}
	document.getElementById("apply_seed").disabled = flag;
}

function getStylingFactory(styles) {
	
	let circleType = styles.circleStyle;
	let ringType = styles.ringStyle;
	let sizeType = styles.sizeStyle;
	
	if (ringType === "None" && circleType === "None")
		stylingFuncObject = Object.assign({}, defaultStylingFuncArr0);
	else if (ringType === "None")
		stylingFuncObject = Object.assign({}, defaultStylingFuncArr1);
	else
		stylingFuncObject = Object.assign({}, defaultStylingFuncArr2);
	
	
	if (circleType !== "None") {
		switch(circleType) {
			case "Species":
				stylingFuncObject.func = speciesFunc;
				break;
			case "Governments":
				stylingFuncObject.func = governmentFunc;
				break;
			case "Economies":
				stylingFuncObject.func = economyFunc;
				break;
			case "Tech Levels":
				stylingFuncObject.func = techFunc;
				break;
			case "Tech Levels":
				stylingFuncObject.func = techFunc;
				break;
			case "Productivity":
				stylingFuncObject.func = productivityFunc;
				break;
			case "Population":
				stylingFuncObject.func = populationFunc;
				break;
			case "Planet Radius":
				stylingFuncObject.func = radiusFunc;
				break;
		}
	}
	
	if (ringType !== "None") {
		
		switch(ringType) {
			case "Species":
				stylingFuncObject.func2 = speciesFunc;
				break;
			case "Governments":
				stylingFuncObject.func2 = governmentFunc;
				break;
			case "Economies":
				stylingFuncObject.func2 = economyFunc
				break;
			case "Tech Levels":
				stylingFuncObject.func2 = techFunc;
				break;
			case "Productivity":
				stylingFuncObject.func2 = productivityFunc;
				break;
			case "Population":
				stylingFuncObject.func2 = populationFunc;
				break;
			case "Planet Radius":
				stylingFuncObject.func2 = radiusFunc;
				break;
		}
	}
	
	if (sizeType !== "None") {
		switch(sizeType) {
			case "Tech Levels":
				stylingFuncObject.func3 = techFunc;
				break;
			case "Productivity":
				stylingFuncObject.func3 = productivityFunc;
				break;
			case "Population":
				stylingFuncObject.func3 = populationFunc;
				break;
			case "Planet Radius":
				stylingFuncObject.func3 = radiusFunc;
				break;
		}
	}
	
	stylingFuncObject.aOptions = styles; //circleType + "-" + ringType + "-" + sizeType;

	return function (sys, stylingFuncObj) {
		return {
			aOptions: stylingFuncObj.aOptions,
			aFrontColor: (stylingFuncObj.func) ? stylingFuncObj.func(sys).aFrontColor : stylingFuncObj.aFrontColor(sys),
			aFrontColor2: (stylingFuncObj.aFrontColor2) ? ((stylingFuncObj.func2) ? stylingFuncObj.func2(sys).aFrontColor : stylingFuncObj.aFrontColor(sys)) : null,
			aStrokeColor: stylingFuncObj.aStrokeColor(sys),
			aStrokeWeight: stylingFuncObj.aStrokeWeight(sys),
			aSystemShape: (((stylingFuncObj.func) ? stylingFuncObj.func(sys).aSystemShape : stylingFuncObj.aSystemShape(sys)) !== "Circle") ? ((stylingFuncObj.func) ? stylingFuncObj.func(sys).aSystemShape : stylingFuncObj.aSystemShape(sys)) : ((stylingFuncObj.func2) ? stylingFuncObj.func2(sys).aSystemShape : stylingFuncObj.aSystemShape(sys)),
			aSystemSize: ((stylingFuncObj.func3) ? stylingFuncObj.func3(sys).aSystemSize : stylingFuncObj.aSystemSize(sys))
		};
	}
	
}

function updatedCombobox(id, list) {
	
	var combobox = document.getElementById(id);		

	while (combobox.firstChild) {
		combobox.removeChild(combobox.firstChild);
	}
	
	list.forEach(e => {
		combobox.options[combobox.options.length] = new Option(e, e);
	});
	
}

function changeStyle(typesObj) {
	
	styles = Object.assign(styles, typesObj);

	if (typesObj.circleStyle) {
		//circleStyle = circleValue;
		changeKey("circle-key", typesObj.circleStyle);
	}
	if (typesObj.ringStyle) {
		//ringStyle = ringValue;
		changeKey("ring-key", typesObj.ringStyle);
	}
	if (typesObj.sizeStyle) {
		//ringStyle = ringValue;
		changeKey("size-key", typesObj.sizeStyle);
	}
	updateStylingDetails(styles);
	S.Draw();
	if (selectidxs.length >= 2) redrawRoute();
	if (searchList && searchList.length > 1)
	{
		redrawSelectors(["search"]);
		displaySearchResults(name);
	}

}

function updateStylingDetails(styles) {
	systemStyleFunc = getStylingFactory(styles);
	S.Poly.filter(e => (e.ParentObject)).forEach(e => { 
		e.ParentObject.stylingType = styles;
		let styling = systemStyleFunc(galArray[e.Id], stylingFuncObject);
		e.ParentObject.FrontColor = styling.aFrontColor;
		e.FrontColor = styling.aFrontColor;
		e.ParentObject.FrontColor2 = styling.aFrontColor2 || null;
		e.ParentObject.StrokeColor = styling.aFrontColor2 || null;
		e.StrokeColor = styling.aStrokeColor;
		e.ParentObject.StrokeWeight = styling.aStrokeWeight;
		e.StrokeWeight = styling.aStrokeWeight;
		e.ParentObject.SystemShape = styling.aSystemShape;
		e.ParentObject.SystemSize = styling.aSystemSize;
	});
}


function speciesKey(id, type, values) {
	standardKey(id, type, values, speciesFunc);
}

function governmentsKey(id, type, values) {
	standardKey(id, type, values, governmentFunc);
}

function economiesKey(id, type, values) {
	standardKey(id, type, values, economyFunc);
}

function techLevelKey(id, type, values) {
	standardKey(id, type, values, techFunc);
}

function productivityKey(id, type, values) {
	standardKey(id, type, values, productivityFunc);
}

function populationKey(id, type, values) {
	standardKey(id, type, values, populationFunc);
}

function radiusKey(id, type, values) {
	standardKey(id, type, values, radiusFunc);
}

function noKey(id, type, values) {
	let keyElement = document.getElementById(id);
	keyElement.replaceChildren();
}

function standardKey(id, type, values, stylingFunc) {
	let keyOption = id;
	let radius = 6;
	if (id === "size-key") radius = 5;
	let weight = 1;
	let keyElement = document.getElementById(id);
	
	keyElement.replaceChildren();
	
	let odd = (values.length % 2 === 1);
	let mid = Math.floor(values.length / 2);
	
	styles2 = {
		circleStyle: "None",
		ringStyle: "None",
		sizeStyle: "None"
	};
	switch (id) {
		case "circle-key":
			styles2.circleStyle = styles.circleStyle;
			break;
		case "ring-key":
			styles2.ringStyle = styles.ringStyle;
			break;
		case "size-key":
			styles2.sizeStyle = styles.sizeStyle;
			break;
		
	}
	
	values.toReversed().forEach((e, i) => {
		
		let symbolDiv = document.createElement("div");
		symbolDiv.setAttribute("class", "key-entry");
		let styling;
		let styleData = stylingFunc(e);
		if (keyOption === "size-key") {
			styling = {
				stylingType: styles2,
				FrontColor: defaultStylingFuncArr1.aFrontColor(),
				FrontColor2: null,
				StrokeColor: defaultStylingFuncArr1.aStrokeColor(),
				StrokeWeight: defaultStylingFuncArr1.aStrokeWeight(),
				attenuation: 1,
				SystemShape: "Circle",
				SystemSize: styleData.aSystemSize
			}
		}
		else if (type === "circle") {
			styling = {
				stylingType: styles2,
				FrontColor: styleData.aFrontColor,
				FrontColor2: null,
				StrokeColor: defaultStylingFuncArr1.aStrokeColor(),
				StrokeWeight: defaultStylingFuncArr1.aStrokeWeight(),
				attenuation: 1,
				SystemShape: styleData.aSystemShape,
				SystemSize: 1 //styleData.aSystemSize
			}
		}
		else {
			styling = {
				stylingType: styles2,
				FrontColor: "#000000",
				FrontColor2: styleData.aFrontColor,
				StrokeColor: defaultStylingFuncArr2.aStrokeColor(),
				StrokeWeight: defaultStylingFuncArr2.aStrokeWeight(),
				attenuation: 1,
				SystemShape: styleData.aSystemShape,
				SystemSize: 1 //styleData.aSystemSize
			}
		}
		let symbol = createSymbol(document, "key-symbol", radius, styling, "key");
		symbol.setAttribute("value", e);
		let viewbox = symbol.getAttribute("viewbox");
		symbol.removeAttribute("viewbox")
		
		let vs = viewbox.split(" ");
		
		let svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
		svg.setAttribute("class", "key-symbol");
		svg.appendChild(symbol);
		svg.setAttribute("width", vs[2]);
		svg.setAttribute("height", vs[3]);
		svg.setAttribute("viewbox", viewbox);

		let symbolContainer = svg;
		if (id === "size-key") {
			symbolContainer = document.createElement("div");
			symbolContainer.setAttribute("class", "size-symbol-container");
			symbolContainer.appendChild(svg);
		}

		symbolDiv.appendChild(symbolContainer);
		
		let textElement = document.createElement("span");
		textElement.textContent = ((keyOption === "size-key") ? styleData.aLabelContinuous : styleData.aLabelRange) || e;
		textElement.setAttribute("class", "key-label");
		symbolDiv.appendChild(textElement);
		
		if (odd) {
			if (i === mid - 1) {
				symbolDiv.setAttribute("class", symbolDiv.getAttribute("class") + " no-column-break");
			}
			if (i === mid) {
				symbolDiv.setAttribute("class", symbolDiv.getAttribute("class") + " column-break");
			}
		}
		
		keyElement.appendChild(symbolDiv);

	});
	
	if (id === "size-key") {
		let maxwidth = [...document.querySelectorAll(".size-symbol-container")].map(e => e.getBoundingClientRect().width).reduce((a, c) => Math.max(a, c));
		document.querySelectorAll(".size-symbol-container").forEach(e => e.style.width = maxwidth);
	}
	
}


function changeKey(id, type) {
	let values = null;
	let keyFunc = noKey;
	let subType = "circle";
	switch (type) {
		case "Species":
		case "Governments":
		case "Economies":
		case "Tech Levels":
		case "Productivity":
		case "Population":
		case "Planet Radius":
			values = lookupArrays[type];
			break;	
	}
	switch (type) {
		case "Species":
			keyFunc = speciesKey;
			break;
		case "Governments":
			keyFunc = governmentsKey;
			break;
		case "Economies":
			keyFunc = economiesKey;
			break;
		case "Tech Levels":
			keyFunc = techLevelKey;
			break;
		case "Productivity":
			keyFunc = productivityKey;
			break;
		case "Population":
			keyFunc = populationKey;
			break;
		case "Planet Radius":
			keyFunc = radiusKey;
			break;
	}
	if (id === "ring-key") subType = "ring";
	
	keyFunc(id, subType, values);
	
}


//Array.prototype.toReversed Polyfill
if (!Array.prototype.toReversed) {
 Array.prototype.toReversed = function() {
    let newArray = this.slice(0);
	newArray.reverse();
    return newArray;
  }
}



onload=Init;
